package demo.common;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

import demo.frame.*;



/**
 * 功能列表界面
 */
public class FunctionList extends JFrame {
	private static final long serialVersionUID = 1L;
	
	public FunctionList() {
	    setTitle(Res.string().getFunctionList());
	    getContentPane().setLayout(new BorderLayout());
	    pack();
	    setSize(399, 322);
	    setResizable(false);
	    setLocationRelativeTo(null);
        	    
	    getContentPane().add(new FunctionPanel(), BorderLayout.CENTER);
 
	    addWindowListener(new WindowAdapter() {
	    	public void windowClosing(WindowEvent e) {
	    		dispose();	
	    		System.exit(0);
	    	}
	    });
	}
	
	public class FunctionPanel extends JPanel {
		private static final long serialVersionUID = 1L;
		
		public FunctionPanel() {
			setLayout(new GridLayout(9, 2));
			
			setBorder(new EmptyBorder(10, 10, 10, 10));
			
			faceRecognitionBtn = new JButton(Res.string().getFaceRecognition());
			faceRecognitionIPCBtn = new JButton(Res.string().getFaceRecognitionIPC());
			capturePictureBtn = new JButton(Res.string().getCapturePicture());
			realPlayBtn = new JButton(Res.string().getRealplay());
			itsEventBtn = new JButton(Res.string().getITSEvent());
			downloadBtn = new JButton(Res.string().getDownloadRecord());
			talkBtn = new JButton(Res.string().getTalk());
			deviceSearchAndInitBtn = new JButton(Res.string().getDeviceSearchAndInit());
			ptzBtn = new JButton(Res.string().getPTZ());
			deviceCtlBtn = new JButton(Res.string().getDeviceControl());
			alarmListenBtn = new JButton(Res.string().getAlarmListen());
			autoRegisterBtn = new JButton(Res.string().getAutoRegister());
			attendanceBtn = new JButton(Res.string().getAttendance());
			gateBtn = new JButton(Res.string().getGate());
			thermalCameraBtn = new JButton(Res.string().getThermalCamera());
			
			vehicleRecognitionBtn = new JButton(Res.string().getVehicleRecognition());
			loginP2PBtn = new JButton(Res.string().loginP2P());
			
			faceRecognitionBtn.setVisible(true);
			faceRecognitionIPCBtn.setVisible(true);
			capturePictureBtn.setVisible(false);
			realPlayBtn.setVisible(true);
			itsEventBtn.setVisible(false);
			downloadBtn.setVisible(true);
			talkBtn.setVisible(false);
			deviceSearchAndInitBtn.setVisible(false);
			ptzBtn.setVisible(true);
			deviceCtlBtn.setVisible(true);
			alarmListenBtn.setVisible(false);
			autoRegisterBtn.setVisible(false);
			attendanceBtn.setVisible(false);
			gateBtn.setVisible(false);
			thermalCameraBtn.setVisible(true);
			vehicleRecognitionBtn.setVisible(true);
			loginP2PBtn.setVisible(true);
			
			add(faceRecognitionBtn);
			add(faceRecognitionIPCBtn);
			add(deviceSearchAndInitBtn);
			add(ptzBtn);
			add(realPlayBtn);
			add(capturePictureBtn);
			add(talkBtn);
			add(itsEventBtn);
			add(downloadBtn);
			add(deviceCtlBtn);
			add(alarmListenBtn);
			add(autoRegisterBtn);
			add(attendanceBtn);
			add(gateBtn);
			add(thermalCameraBtn);
			add(vehicleRecognitionBtn);
			add(loginP2PBtn);
			loginP2PBtn.addActionListener(new ActionListener() {
				@Override
				public void actionPerformed(ActionEvent arg0) {
					SwingUtilities.invokeLater(new Runnable() {
						public void run() {
							dispose();
							P2PLogin.main(null);
						}												
					});
				}
			});
			vehicleRecognitionBtn.addActionListener(new ActionListener() {		
				@Override
				public void actionPerformed(ActionEvent arg0) {		
					SwingUtilities.invokeLater(new Runnable() {
						public void run() {	
							dispose();
							VehicleRecognize.main(null);
						}
					});	
				}
			});
			faceRecognitionBtn.addActionListener(new ActionListener() {		
				@Override
				public void actionPerformed(ActionEvent arg0) {		
					SwingUtilities.invokeLater(new Runnable() {
						public void run() {	
							dispose();
							//FaceRecognition.main(null);
							FaceRecognize.main(null);
						}
					});	
				}
			});
			faceRecognitionIPCBtn.addActionListener(new ActionListener() {
				@Override
				public void actionPerformed(ActionEvent arg0) {
					SwingUtilities.invokeLater(new Runnable() {
						public void run() {	
							dispose();
							IPCFaceMatch.main(null);
							//JOptionPane.showMessageDialog(null, "未完成", "", JOptionPane.ERROR_MESSAGE);	
						}
					});	
				}
			});
			
			capturePictureBtn.addActionListener(new ActionListener() {		
				@Override
				public void actionPerformed(ActionEvent arg0) {		
					SwingUtilities.invokeLater(new Runnable() {
						public void run() {	
							dispose();
							//CapturePicture.main(null);
						}
					});	
				}
			});
			
			realPlayBtn.addActionListener(new ActionListener() {		
				@Override
				public void actionPerformed(ActionEvent arg0) {		
					SwingUtilities.invokeLater(new Runnable() {
						public void run() {	
							dispose();
							RealPlay.main(null);
						}
					});	
				}
			});
			
			downloadBtn.addActionListener(new ActionListener() {		
				@Override
				public void actionPerformed(ActionEvent arg0) {	
					SwingUtilities.invokeLater(new Runnable() {
						public void run() {		
							dispose();
							DownLoadRecord.main(null);
						}
					});	
				}
			});
			
			talkBtn.addActionListener(new ActionListener() {		
				@Override
				public void actionPerformed(ActionEvent arg0) {	
					SwingUtilities.invokeLater(new Runnable() {
						public void run() {		
							dispose();
							//Talk.main(null);
						}
					});	
				}
			});
			
			
			itsEventBtn.addActionListener(new ActionListener() {		
				@Override
				public void actionPerformed(ActionEvent arg0) {		
					SwingUtilities.invokeLater(new Runnable() {
						public void run() {		
							dispose();
							//TrafficEvent.main(null);
						}
					});	
				}
			});
			
			deviceSearchAndInitBtn.addActionListener(new ActionListener() {		
				@Override
				public void actionPerformed(ActionEvent arg0) {		
					SwingUtilities.invokeLater(new Runnable() {
						public void run() {		
							dispose();
							//DeviceSearchAndInit.main(null);
						}
					});	
				}
			});
			
			ptzBtn.addActionListener(new ActionListener() {		
				@Override
				public void actionPerformed(ActionEvent arg0) {		
					SwingUtilities.invokeLater(new Runnable() {
						public void run() {	
							dispose();
							PTZControl.main(null);
						}
					});	
				}
			});
			
			deviceCtlBtn.addActionListener(new ActionListener() {		
				@Override
				public void actionPerformed(ActionEvent arg0) {		
					SwingUtilities.invokeLater(new Runnable() {
						public void run() {	
							dispose();
							DeviceControl.main(null);
						}
					});	
				}
			});
			
			alarmListenBtn.addActionListener(new ActionListener() {		
				@Override
				public void actionPerformed(ActionEvent arg0) {		
					SwingUtilities.invokeLater(new Runnable() {
						public void run() {	
							dispose();
							//AlarmListen.main(null);
						}
					});	
				}
			});
			
			autoRegisterBtn.addActionListener(new ActionListener() {		
				@Override
				public void actionPerformed(ActionEvent arg0) {		
					SwingUtilities.invokeLater(new Runnable() {
						public void run() {	
							dispose();
							//AutoRegister.main(null);
						}
					});	
				}
			});
			
			attendanceBtn.addActionListener(new ActionListener() {		
				@Override
				public void actionPerformed(ActionEvent arg0) {		
					SwingUtilities.invokeLater(new Runnable() {
						public void run() {	
							dispose();
							//Attendance.main(null);
						}
					});	
				}
			});
			
			gateBtn.addActionListener(new ActionListener() {		
				@Override
				public void actionPerformed(ActionEvent arg0) {		
					SwingUtilities.invokeLater(new Runnable() {
						public void run() {	
							dispose();
							//Gate.main(null);
						}
					});	
				}
			});
			
			thermalCameraBtn.addActionListener(new ActionListener() {		
				@Override
				public void actionPerformed(ActionEvent arg0) {		
					SwingUtilities.invokeLater(new Runnable() {
						public void run() {	
							dispose();
							Thermal.main(null);
						}
					});	
				}
			});
		}
		
		/*
		 * 功能列表组件
		 */
		private JButton faceRecognitionBtn;
		private JButton capturePictureBtn;
		private JButton realPlayBtn;
		private JButton downloadBtn;
		private JButton itsEventBtn;
		private JButton talkBtn;
		private JButton deviceSearchAndInitBtn;
		private JButton ptzBtn;
		private JButton deviceCtlBtn;
		private JButton alarmListenBtn;
		private JButton autoRegisterBtn;
		private JButton attendanceBtn;
		private JButton gateBtn;
		private JButton thermalCameraBtn;
				
		private JButton vehicleRecognitionBtn;
		private JButton loginP2PBtn;
		private JButton faceRecognitionIPCBtn;

	}
}
